//---------------------------
// UCL-CEREM-MBS
//
// @version MBsysLab_s 1.7.a
//
// Creation : 2006
// Last update : 01/10/2008
//---------------------------

#include "math.h"

#include "mbs_data.h"
#include "user_all_id.h"

void user_DrivenJoints(MbsData *mbs_data,double tsim)
{

    // Robot trajectory (harmonic motion in x, y, z of the platform)
    double f = 0.5;
    double om = 2 * M_PI *f;
    double a = 0.2;

    mbs_data->q[TzPlatform_id] = 0.9 + a * sin(om*tsim);
    mbs_data->qd[TzPlatform_id] = a * om*cos(om*tsim);
    mbs_data->qdd[TzPlatform_id] = -a * om*om * sin(om*tsim);

    f = 1;
    om = 2 * M_PI*f;
    a = 0.1;

    mbs_data->q[TxPlatform_id] = a * sin(om*tsim);
    mbs_data->qd[TxPlatform_id] = a * om*cos(om*tsim);
    mbs_data->qdd[TxPlatform_id] = -a * om*om * sin(om*tsim);

    mbs_data->q[TyPlatform_id] = a * cos(om*tsim);
    mbs_data->qd[TyPlatform_id] = -a * om*sin(om*tsim);
    mbs_data->qdd[TyPlatform_id] = -a * om*om * cos(om*tsim);

}

 
